function Psi = streamlinesv( B, line_count, linestyle )
% Psi = streamlinesv( B, line_count )
% 
% Plots streamlines for a 2D mflab flow model with vertical flow.
% B is a struct as created by the mflab readbud function
% contour_count is an optional parameter specifying the number of
% streamlines. Streamlines are created by contouring the flow function.


if nargin == 1, 
    line_count = 100; 
    linestyle = 'w-';
elseif nargin == 2,
    linestyle = 'w-';
end

termidx = find(ismember(B.label, 'FLOWFRONTFACE')==1);

Qy = B.term{ termidx };

Psi = [ cumsum(  Qy, 2)  zeros(  size( Qy, 1), 1) ];

plotcontours( Psi, line_count, false, linestyle )

